﻿using System;
using System.IO;
using System.Threading;
using System.Xml.Serialization;
using System.Configuration;
using System.Threading.Tasks;

namespace PerformanceTesting
{
    public class TestRunner : ITestRunner
    {
        private Test test;
        private CountdownEvent countdown;
        private Barrier[] stepBarriers;

        public void RunTest()
        {
            if (test == null)
                throw new Exception("Test not loaded");

            DialogFactory dialogFactory = new DialogFactory(test.Address);

            //ThreadPool.SetMaxThreads(test.Clients, test.Clients);
            //System.Net.ServicePointManager.DefaultConnectionLimit = 1000;
            //int maxThreads = Int32.Parse(ConfigurationManager.AppSettings[Constants.MaxThreadNumber]);
            ThreadPool.SetMinThreads(500, 500);
            ThreadPool.SetMaxThreads(1000, 1000);
            countdown = new CountdownEvent(test.Clients);

            Task[] tasks = new Task[test.Clients];
            for (int i = 0; i < test.Clients; i++)
            {
                //queue test to run
                tasks[i] = Task.Factory.StartNew(() =>
                {
                    var data = new TestRunnerData(test, dialogFactory.GetDialog(), countdown, StepBarriers);
                    RunTest(data);
                });

                //wait before starting new test
                if (test.ClientStartDelay > 0)
                    Thread.Sleep(test.ClientStartDelay);
            }
            Task.WaitAll(tasks);
            foreach (Task t in tasks)
                t.Dispose();
            tasks = null;

            //Parallel.For(0, test.Clients, i =>
            //{
            //    int j = i;
            //    var data = new
            //    {
            //        Test = test,
            //        Dialog = dialogFactory.GetDialog(),
            //        Countdown = countdown,
            //        Barriers = StepBarriers
            //    };
            //    data.Test.RunSteps(data.Dialog, data.Barriers);
            //    data.Countdown.Signal();
            //});
        }

        public void RunTest(TestRunnerData data)
        {
            data.Test.RunSteps(data.Dialog, data.Barriers);
            data.Countdown.Signal();
        }

        public Barrier[] StepBarriers 
        {
            get 
            {
                if (stepBarriers == null)
                {
                    stepBarriers = new Barrier[test.Steps.Count];
                    for (int i = 0; i < test.Steps.Count; i++)
                        stepBarriers[i] = new Barrier(test.Clients);
                }
                return stepBarriers;
            }
        }

        public ITest Test
        {
            get { return test; }
        }

        public ITest Load(string path)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(Test));
            FileStream stream = new FileStream(path, FileMode.Open);
            test = (Test)serializer.Deserialize(stream);

            return test;
        }


        public void WaitForTestEnd()
        {
            countdown.Wait();
        }

        public string GetTestParams()
        {
            return String.Format("Clients: {0} | Address: {1}", test.Clients, test.Address);
        }
    }
}
